import { usePlaybackRestrictions } from 'pulsar';
import type { Variables } from 'relay-runtime';
import { useStaticEnvironment } from 'tachyon-environment';
import { useRefetchableFragmentWithoutSuspense } from 'tachyon-relay';
import type {
  CombinedOpts,
  useRefetchPlaybackAccessTokenChannel,
  useRefetchPlaybackAccessTokenChannelOpts,
  useRefetchPlaybackAccessTokenClip,
  useRefetchPlaybackAccessTokenClipOpts,
  useRefetchPlaybackAccessTokenVod,
  useRefetchPlaybackAccessTokenVodOpts,
  useRefetchPlaybackAccessTokenVodPreview,
  useRefetchPlaybackAccessTokenVodPreviewOpts,
} from './types';

export type {
  useRefetchPlaybackAccessTokenChannelOpts,
  useRefetchPlaybackAccessTokenClipOpts,
  useRefetchPlaybackAccessTokenVodOpts,
  useRefetchPlaybackAccessTokenVodPreviewOpts,
  PlaybackAccessTokenStatus,
} from './types';

export function useRefetchPlaybackAccessToken(
  opts: useRefetchPlaybackAccessTokenChannelOpts,
): useRefetchPlaybackAccessTokenChannel;
export function useRefetchPlaybackAccessToken(
  opts: useRefetchPlaybackAccessTokenClipOpts,
): useRefetchPlaybackAccessTokenClip;
export function useRefetchPlaybackAccessToken(
  opts: useRefetchPlaybackAccessTokenVodOpts,
): useRefetchPlaybackAccessTokenVod;
export function useRefetchPlaybackAccessToken(
  opts: useRefetchPlaybackAccessTokenVodPreviewOpts,
): useRefetchPlaybackAccessTokenVodPreview;
export function useRefetchPlaybackAccessToken({
  playerType,
  refetchQuery,
  tokenFragment,
  tokenRef,
  ...restProps
}: CombinedOpts): any {
  const {
    common: { platform },
  } = useStaticEnvironment();
  const { addRestriction } = usePlaybackRestrictions();
  const [token, refetchToken] = useRefetchableFragmentWithoutSuspense(
    tokenFragment,
    tokenRef,
    refetchQuery,
  );

  const refetchTokenOpts = {
    platform,
    playerType,
    skipPlayToken: false,
    ...restProps,
  } as Partial<Variables>;

  return {
    refetchToken: () => {
      refetchToken(refetchTokenOpts, {
        onComplete: (error) => {
          if (error) {
            addRestriction('playback-error');
          }
        },
      });
    },
    token,
  };
}
