import type { PlayerType } from 'pulsar';
import type { GraphQLTaggedNode } from 'relay-runtime';
import type { ClipPlayer_token, ClipPlayer_token$key } from '../ClipPlayer';
import type {
  StreamPlayer_token,
  StreamPlayer_token$key,
} from '../StreamPlayer';
import type {
  VodPlayerWrapper_token,
  VodPlayerWrapper_token$key,
  VodPreviewPlayerWrapper_previewToken,
  VodPreviewPlayerWrapper_previewToken$key,
} from '../VodPlayer';

export type PlaybackAccessTokenStatus =
  | 'error'
  | 'fulfilled'
  | 'initialized'
  | 'pending';

export type useRefetchPlaybackAccessTokenOpts = {
  playerType: PlayerType;
  refetchQuery: GraphQLTaggedNode;
  tokenFragment: GraphQLTaggedNode;
};

export type useRefetchPlaybackAccessTokenChannelOpts =
  useRefetchPlaybackAccessTokenOpts & {
    login: string;
    tokenRef: StreamPlayer_token$key;
  };

export type useRefetchPlaybackAccessTokenClipOpts =
  useRefetchPlaybackAccessTokenOpts & {
    slug: string;
    tokenRef: ClipPlayer_token$key;
  };

export type useRefetchPlaybackAccessTokenVodOpts =
  useRefetchPlaybackAccessTokenOpts & {
    tokenRef: VodPlayerWrapper_token$key;
    videoId: string;
  };

export type useRefetchPlaybackAccessTokenVodPreviewOpts =
  useRefetchPlaybackAccessTokenOpts & {
    tokenRef: VodPreviewPlayerWrapper_previewToken$key;
    videoId: string;
  };

export type useRefetchPlaybackAccessToken = {
  refetchToken: () => void;
};

export type useRefetchPlaybackAccessTokenChannel =
  useRefetchPlaybackAccessToken & {
    token: StreamPlayer_token;
  };

export type useRefetchPlaybackAccessTokenClip =
  useRefetchPlaybackAccessToken & {
    token: ClipPlayer_token;
  };

export type useRefetchPlaybackAccessTokenVod = useRefetchPlaybackAccessToken & {
  token: VodPlayerWrapper_token;
};

export type useRefetchPlaybackAccessTokenVodPreview =
  useRefetchPlaybackAccessToken & {
    token: VodPreviewPlayerWrapper_previewToken;
  };

export type CombinedOpts =
  | useRefetchPlaybackAccessTokenChannelOpts
  | useRefetchPlaybackAccessTokenClipOpts
  | useRefetchPlaybackAccessTokenVodOpts
  | useRefetchPlaybackAccessTokenVodPreviewOpts;

export type CombinedTokens =
  | ClipPlayer_token
  | StreamPlayer_token
  | VodPlayerWrapper_token
  | VodPreviewPlayerWrapper_previewToken;
