import type { ExperimentSlots } from 'tachyon-experiments';
// On staging: The experiment_overrides query param is the expected use-case for
// toggling experiments groups. You can also change your bucket by adding an
// `x-bucket-id` header to your requests, but the query param method
// is much easier since buckets are randomly distributed wihtin experiments.
export const EXPERIMENT_OVERRIDES_QUERY_PARAM_KEY = 'experiment_overrides';
// express downcases headers since they are not case sensitive
export const EXPERIMENT_BUCKET_HEADER = 'x-bucket-id';

// An experiment's slot must remain constant for the duration of the experiment,
// otherwise the user may be moved into a different experiment group.
export const EXPERIMENT_SLOTS: ExperimentSlots = {
  0: undefined,
  1: undefined,
  2: undefined,
};
