import type { BackendService } from 'tachyon-relay';

// This is config is still experimental. Consult with Emerging Platforms
// Engineeering before altering anything in here.

// Use the exact name of your query, as the relay-compiler ensures name
// uniqueness and will help prevent collisions. Be sure to include any relevant
// refetch queries as well (e.g. for infinite lists, etc).
export const ALLOWED_PARTIAL_RESPONSE_QUERIES: string[] = [
  'Channel_Query',
  'ChannelHome_Query',
  'ChannelInterstitial_Query',
  'Clip_Query',
  'ClipInterstitial_Query',
  'Homepage_Query',
  'Search_Query',
  'Vod_Query',
  'VodInterstitial_Query',
];

// /////////////////////////////////////////////////////////////////////////////
// Don't commit any changes below here, should only be altered for local dev  //
// /////////////////////////////////////////////////////////////////////////////

// Change this to true to enable debug mode in tachyon-relay; necessary for
// emulating service failures in addition to other behavior changes.
// eslint-disable-next-line @typescript-eslint/no-inferrable-types
export const GQL_DEBUG_MODE: boolean = false;

// You must be on the Amazon network for service failure simulation to work
export const GQL_SANDBOX_ENDPOINT = 'https://graphql.twitch.a2z.com/master/gql';

// Add service names to this list to enable simulated failures. TS will
// autocomplete service names for you.
export const FAIL_SERVICES: BackendService[] = [
  // 'Graffiti',
  // 'Users',
  // 'Liveline',
];
