import type { PulsarBackend } from 'pulsar';
import { Platform } from 'tachyon-environment';

export const PLAYER_INITIAL_OFFSET_QUERY_PARAM_KEY = 't';

const PREFERS_HLSJS = [Platform.FireTV, Platform.Vizio, Platform.Vestel];
const PREFERS_NATIVE_HLS = [Platform.Switch];

// istanbul ignore next: trivial
export function getPulsarChannelOrVodBackend(
  platform: Platform,
): PulsarBackend {
  if (PREFERS_HLSJS.includes(platform)) {
    return 'hlsjs';
  }

  if (PREFERS_NATIVE_HLS.includes(platform)) {
    return 'native';
  }

  return 'mediaplayer';
}

// istanbul ignore next: trivial
export function getPulsarClipBackend(platform: Platform): PulsarBackend {
  // HLS.js does not support MP4s, can't be used for Clips, use the native player instead
  if (
    PREFERS_HLSJS.includes(platform) ||
    PREFERS_NATIVE_HLS.includes(platform)
  ) {
    return 'native';
  }

  return 'mediaplayer';
}
