export type DomainList = Array<{
  name?: string;
  url: string;
}>;

// This code is unsafe to import into application logic! Only import this in
// code that you're certain only runs on the server. We don't want to leak these
// domains to the public. To that end, it is intentionally not placed in the
// config directory to help prevent accidental bundling into client code.
// istanbul ignore next: trivial
export const dangerousDomainList: DomainList = [
  {
    name: 'Staging Main',
    url: 'https://87hn6uil7zv5hvmly5mz.tv.twitch.a2z.com',
  },
  { url: 'https://fix7y1uvk4b1ahet92bx.tv.twitch.a2z.com' },
  { url: 'https://j7738ebzthft3lh5e2g0.tv.twitch.a2z.com' },
  { url: 'https://dmwhop68wex46a485ze6.tv.twitch.a2z.com' },
  { url: 'https://osposbc8hid4yfli2i3e.tv.twitch.a2z.com' },
  {
    name: 'LG Production 1',
    url: 'https://lzfnhhvpeppznbnngsio.tv.twitch.tv',
  },
  {
    name: 'LG Production 2',
    url: 'https://ushbsamruavydrm2.lg.tv.twitch.tv',
  },
  {
    name: 'Vestel Production 1',
    url: 'https://lifonkblzxzuckp1.vestel.tv.twitch.tv',
  },
  {
    name: 'Switch Production 1',
    url: 'https://mrohkkcptggjkje1.switch.tv.twitch.tv/',
  },
  {
    name: 'Partner Public Preview',
    url: 'https://ryxjogfhxnvjuptmzkhk.tv.twitch.tv',
  },
  { name: 'Local', url: 'https://localhost.tv.twitch.tv' },
  { name: 'Emp Dev 0', url: 'https://empdev0.dev.emp.twitch.a2z.com' },
  { name: 'Emp Dev 1', url: 'https://empdev1.dev.emp.twitch.a2z.com' },
  { name: 'Emp Dev 2', url: 'https://empdev2.dev.emp.twitch.a2z.com' },
  { name: 'Emp Dev 3', url: 'https://empdev3.dev.emp.twitch.a2z.com' },
  { name: 'Emp Dev 4', url: 'https://empdev4.dev.emp.twitch.a2z.com' },
  { name: 'Emp Dev 5', url: 'https://empdev5.dev.emp.twitch.a2z.com' },
];
