import { renderHook } from '@testing-library/react-hooks';
import { random } from 'faker';
import { validId } from 'tachyon-relay';
import type { FollowTargetChannel } from '.';
import { useFollow } from '.';

jest.mock('../useStarshotMutation', () => ({
  useStarshotMutation: jest.fn(),
}));

describe(useFollow, () => {
  function setup(
    channel: FollowTargetChannel = {
      id: validId('12345'),
      self: {
        follower: {
          followedAt: random.alphaNumeric(),
        },
      },
    },
  ) {
    return renderHook((props) => useFollow(props), {
      initialProps: channel,
    });
  }

  it('returns a following status of true if the user follows the channel', () => {
    const { result } = setup();
    expect(result.current.following).toEqual(true);
  });

  it('returns a following status of true if the user does not follow the channel', () => {
    const { result } = setup({
      id: validId('1234'),
      self: {
        follower: null,
      },
    });
    expect(result.current.following).toEqual(false);
  });

  it('returns a following status of false if the follow data is invalid', () => {
    const { result } = setup({
      id: validId('1234'),
      self: {
        follower: { followedAt: null },
      },
    });
    expect(result.current.following).toEqual(false);
  });
});
