import { useMemo, useState } from 'react';

// istanbul ignore next: trivial
export const useInterstitialPlayAttempt = (): {
  attemptedPlay: boolean;
  resetAttemptedPlay: () => void;
  triggerAttemptedPlay: () => void;
} => {
  const [attemptedPlay, setAttemptedPlay] = useState(false);

  return useMemo(
    () => ({
      attemptedPlay,
      resetAttemptedPlay: () => {
        setAttemptedPlay(false);
      },
      triggerAttemptedPlay: () => {
        setAttemptedPlay(true);
      },
    }),
    [attemptedPlay],
  );
};
