import { graphql } from 'react-relay/hooks';
import { useIntl } from 'tachyon-intl';
import type {
  AddRecommendationFeedbackInput,
  useNotInterestedMutationVariables,
} from './__generated__/useNotInterestedMutation.graphql';
import { useStarshotMutation } from './useStarshotMutation';

// istanbul ignore next: trivial
export function useNotInterested(
  input: Omit<AddRecommendationFeedbackInput, 'category'>,
): () => void {
  const { formatMessage } = useIntl();
  const commitNotInterested =
    useStarshotMutation<useNotInterestedMutationVariables>({
      errorMessage: formatMessage(
        'Failed to remove interest. Please try again.',
        'useNotInterested',
      ),
      mutation: AddRecommendationFeedback,
    });

  return () => {
    commitNotInterested({
      input: {
        category: 'NOT_INTERESTED',
        ...input,
      },
    });
  };
}

const AddRecommendationFeedback = graphql`
  mutation useNotInterestedMutation($input: AddRecommendationFeedbackInput!) {
    addRecommendationFeedback(input: $input) {
      recommendationFeedback {
        id
      }
    }
  }
`;
