import { useStorage } from 'tachyon-utils';

export const SEARCH_HISTORY_LENGTH = 10;

const SEARCH_HISTORY_STORAGE_KEY = 'search-history';

export type SearchHistory = string[];

interface SearchHistoryObj {
  clearHistory: () => void;
  history: SearchHistory;
  pushTerm: (term: string) => void;
}

/**
 * Returns the most recently used search terms for the user.
 */
export function useSearchHistory(): SearchHistoryObj {
  const [history, setHistory] = useStorage<SearchHistory>(
    SEARCH_HISTORY_STORAGE_KEY,
    [],
  );

  function pushTerm(term: string): void {
    if (history.includes(term)) {
      setHistory([term, ...history.filter((t) => t !== term)]);
    } else {
      // If the search term isn't already in history, add it.
      setHistory([term, ...history.slice(0, SEARCH_HISTORY_LENGTH - 1)]);
    }
  }

  function clear(): void {
    setHistory([]);
  }

  return {
    clearHistory: clear,
    history,
    pushTerm,
  };
}
