import { useEffect, useRef } from 'react';
import type { KeyValue } from 'tachyon-utils';
import { legacyKeyboardEventHandler } from 'tachyon-utils';

export function useSecretCode(
  sequence: Array<KeyValue>,
  onSuccesfulSequence: () => void,
): void {
  const correctKeyCount = useRef(0);

  useEffect(() => {
    const keyCountListener = legacyKeyboardEventHandler((event) => {
      if (event.key === sequence[correctKeyCount.current]) {
        correctKeyCount.current++;
        if (correctKeyCount.current === sequence.length) {
          onSuccesfulSequence();
          correctKeyCount.current = 0;
        }
      } else {
        correctKeyCount.current = 0;
      }
    });
    document.addEventListener('keydown', keyCountListener);
    return () => {
      document.removeEventListener('keydown', keyCountListener);
    };
  }, [sequence, onSuccesfulSequence]);
}
