import { renderHook } from '@testing-library/react-hooks';
import { KeyValue } from 'tachyon-utils';
import { useSecretCode } from '.';

describe('useSecretCode', () => {
  const sequence = [KeyValue.Up, KeyValue.Down];
  const mockOnSuccesfulSequence = jest.fn();
  beforeEach(() => {
    jest.resetAllMocks();
  });

  it('Registers a listener and executes action after key sequence', () => {
    renderHook(() => {
      useSecretCode(sequence, mockOnSuccesfulSequence);
    });
    expect(mockOnSuccesfulSequence).toHaveBeenCalledTimes(0);

    sequence.forEach((key: string) => {
      document.dispatchEvent(new KeyboardEvent('keydown', { key }));
    });

    expect(mockOnSuccesfulSequence).toHaveBeenCalledTimes(1);
  });

  it('Registers a listener that does not perform action when key sequence is interrupted.', () => {
    renderHook(() => {
      useSecretCode(sequence, mockOnSuccesfulSequence);
    });
    expect(mockOnSuccesfulSequence).toHaveBeenCalledTimes(0);

    sequence.forEach((key: string) => {
      document.dispatchEvent(new KeyboardEvent('keydown', { key }));
      document.dispatchEvent(
        new KeyboardEvent('keydown', { key: KeyValue.Left }),
      );
    });

    expect(mockOnSuccesfulSequence).toHaveBeenCalledTimes(0);
  });

  it('Performs action after a succesful sequence after some wrong inputs', () => {
    renderHook(() => {
      useSecretCode(sequence, mockOnSuccesfulSequence);
    });
    expect(mockOnSuccesfulSequence).toHaveBeenCalledTimes(0);

    document.dispatchEvent(
      new KeyboardEvent('keydown', { key: KeyValue.Left }),
    );
    document.dispatchEvent(
      new KeyboardEvent('keydown', { key: KeyValue.Left }),
    );
    sequence.forEach((key: string) => {
      document.dispatchEvent(new KeyboardEvent('keydown', { key }));
    });

    expect(mockOnSuccesfulSequence).toHaveBeenCalledTimes(1);
  });
});
