import type { Notification, NotificationPublisher } from 'tachyon-notification';
import { useNotificationPublisher } from 'tachyon-notification';

export type StarshotNotificationMeta =
  | {
      displayType: 'in-feature-notification';
      message: {
        description: string;
        title: string;
      };
    }
  | {
      displayType: 'snack-bar';
      message: string;
    };

export type StarshotNotification = Notification & {
  meta: StarshotNotificationMeta;
};

// istanbul ignore next: trivial
export const useStarshotNotification: () => NotificationPublisher<StarshotNotificationMeta> =
  useNotificationPublisher;
