import { graphql } from 'react-relay/hooks';
import { useStarshotMutation } from '../../useStarshotMutation';
import type {
  UpdateUserViewedVideoInput,
  VideoType,
  useUpdateUserViewedVideoMutationVariables,
} from './__generated__/useUpdateUserViewedVideoMutation.graphql';

export type UseUpdateUserViewedVideoProps = UpdateUserViewedVideoInput;
export type UseUpdateUserViewedVideoVideoType = VideoType;

type StaticInput = Omit<UseUpdateUserViewedVideoProps, 'position'>;
type DynamicInput = Pick<UseUpdateUserViewedVideoProps, 'position'>;

// istanbul ignore next: trivial
export function useUpdateUserViewedVideo(
  staticInput: StaticInput,
): (dynamicInput: DynamicInput) => void {
  const commitUpdateUserViewedVideo =
    useStarshotMutation<useUpdateUserViewedVideoMutationVariables>({
      errorMessage: null,
      mutation: UpdateUserViewedVideo,
    });

  return (dynamicInput) => {
    commitUpdateUserViewedVideo({
      input: {
        ...staticInput,
        ...dynamicInput,
      },
    });
  };
}

const UpdateUserViewedVideo = graphql`
  mutation useUpdateUserViewedVideoMutation(
    $input: UpdateUserViewedVideoInput!
  ) {
    updateUserViewedVideo(input: $input) {
      video {
        id
      }
    }
  }
`;
