import type { ParsedUrlQuery } from 'querystring';
import { stringify } from 'querystring';
import { useEffectOnce } from 'tachyon-utils';
import { REDIRECT_ROUTE_PARAM_KEY } from '../../../config';
import type { AsPathForRouteNameParams } from '../../linkPartsForRouteName';
import type { RouteName } from '../../routes';
import { useTachyonRouter } from '../../useTachyonRouter';

export function createRedirectQuery(
  path: AsPathForRouteNameParams<RouteName>,
): {
  [REDIRECT_ROUTE_PARAM_KEY]: string;
} {
  const routeParams = stringify(path.routeParams);
  return {
    [REDIRECT_ROUTE_PARAM_KEY]: stringify({ route: path.route, routeParams }),
  };
}

type RedirectProps<T extends RouteName> = {
  params: AsPathForRouteNameParams<T>;
  query?: ParsedUrlQuery;
  replace?: true;
};

export function Redirect<T extends RouteName>({
  params,
  query,
  replace,
}: RedirectProps<T>): null {
  const router = useTachyonRouter();

  useEffectOnce(() => {
    if (replace) {
      router.replace(params, query);
    } else {
      router.push(params, query);
    }
  });

  return null;
}

Redirect.displayName = 'Redirect';
