import { createMountWrapperFactory } from 'tachyon-test-utils';
import { REDIRECT_ROUTE_PARAM_KEY } from '../../../config';
import { RouteName } from '../../routes';
import { mockRouter } from '../../test-mocks';
import { Redirect, createRedirectQuery } from '.';

jest.mock('../../useTachyonRouter', () => ({
  useTachyonRouter: () => mockRouter,
}));

describe(Redirect, () => {
  const setup = createMountWrapperFactory(Redirect, () => ({
    params: { route: RouteName.Homepage, routeParams: {} } as any,
  }));

  beforeEach(() => {
    jest.resetAllMocks();
  });

  it('pushes', () => {
    const { props } = setup();
    expect(mockRouter.push).toHaveBeenCalledWith(props.params, props.query);
  });

  it('replaces', () => {
    const { props } = setup({ replace: true });
    expect(mockRouter.replace).toHaveBeenCalledWith(props.params, props.query);
  });
});

describe(createRedirectQuery, () => {
  it('serializes the route and routeParams', () => {
    expect(
      createRedirectQuery({
        route: RouteName.Channel,
        routeParams: {
          login: 'therealderekt',
        },
      }),
    ).toEqual({
      [REDIRECT_ROUTE_PARAM_KEY]:
        'route=channel&routeParams=login%3Dtherealderekt',
    });
  });
});
