import { pathnameFromRouteName } from '../pathnameFromRouteName';
import { RouteName } from '../routes';
import { linkPartsForRouteName } from '.';

describe(linkPartsForRouteName, () => {
  it('creates a valid asPath for a static route', () => {
    expect(linkPartsForRouteName({ route: RouteName.Homepage })).toEqual({
      href: pathnameFromRouteName(RouteName.Homepage),
    });
  });

  it('creates a valid asPath for a static route with query params', () => {
    const query = { baz: ['boo', 'boop'], foo: 'bar' };
    expect(linkPartsForRouteName({ route: RouteName.Homepage }, query)).toEqual(
      {
        as: `${pathnameFromRouteName(
          RouteName.Homepage,
        )}?baz=boo&baz=boop&foo=bar`,
        href: `${pathnameFromRouteName(
          RouteName.Homepage,
        )}?baz=boo&baz=boop&foo=bar`,
      },
    );
  });

  it('creates a valid asPath for a dynamic route', () => {
    expect(
      linkPartsForRouteName({
        route: RouteName.Channel,
        routeParams: { login: 'therealderekt' },
      }),
    ).toEqual({
      as: '/therealderekt',
      href: pathnameFromRouteName(RouteName.Channel),
    });
  });

  it('creates a valid asPath for a dynamic route with query params', () => {
    const query = { baz: ['boo', 'boop'], foo: 'bar' };
    expect(
      linkPartsForRouteName(
        { route: RouteName.Channel, routeParams: { login: 'therealderekt' } },
        query,
      ),
    ).toEqual({
      as: '/therealderekt?baz=boo&baz=boop&foo=bar',
      href: `${pathnameFromRouteName(
        RouteName.Channel,
      )}?baz=boo&baz=boop&foo=bar`,
    });
  });
});
