import { RouteLinkPathnames, RouteName } from '../routes';

/**
 * Converts a custom RouteName to a Next pathname.
 * Returns the NotFound pathname if there is no matching route.
 */
export function pathnameFromRouteName(name: RouteName): string {
  return RouteLinkPathnames[name] || RouteLinkPathnames[RouteName.NotFound];
}
