import { parse } from 'querystring';
import { Enum } from 'tachyon-utils';
import type {
  AsPathForRouteNameParams,
  AsPathParams,
} from '../linkPartsForRouteName';
import { RouteName } from '../routes';

/**
 * Helper function for turning encoded query string routes into something useful for redirecting
 *
 * @param queryString an encoded query string such as `route%3Dchannel_home%26routeParams%3Dlogin%253Dtherealderekt`
 * @returns undefined if the route is missing or if queryString is falsy, otherwise a route and routeParams
 */
export function routeAndRouteParamsFromQueryString(
  queryString: string | undefined,
): AsPathForRouteNameParams<RouteName> | undefined {
  if (!queryString) {
    return;
  }
  const path = parse(decodeURIComponent(queryString)) as {
    route: RouteName;
    routeParams: string;
  };
  const route = Enum.convertValueFromExternal(RouteName, path.route);
  if (!route) {
    return;
  }
  const routeParams = parse(path.routeParams) as AsPathParams<RouteName>;

  return { route, routeParams };
}
