import { RouteName } from '../routes';
import { routeAndRouteParamsFromQueryString } from '.';

describe(routeAndRouteParamsFromQueryString, () => {
  it('returns the expected route and routeParams', () => {
    const queryString =
      'route%3Dchannel%26routeParams%3Dlogin%253Dtherealderekt';
    expect(routeAndRouteParamsFromQueryString(queryString)).toEqual({
      route: RouteName.Channel,
      routeParams: {
        login: 'therealderekt',
      },
    });
  });

  it('returns undefined when route is missing', () => {
    expect(
      routeAndRouteParamsFromQueryString('routeParams=login%3Dtherealderekt'),
    ).toBeUndefined();
  });

  it('returns undefined when passed an empty string', () => {
    expect(routeAndRouteParamsFromQueryString('')).toBeUndefined();
  });

  it('returns undefined when passed undefined', () => {
    expect(routeAndRouteParamsFromQueryString(undefined)).toBeUndefined();
  });
});
