import { Enum } from 'tachyon-utils';
import { RouteLinkPathnames, RouteName } from '../routes';
import { routeNameFromPathname } from '.';

describe(routeNameFromPathname, () => {
  it.each(Enum.entries(RouteLinkPathnames))(
    'returns %s for path %s',
    (routeName: string, pathname: string) => {
      expect(routeNameFromPathname(pathname)).toEqual(routeName);
    },
  );

  it.each(['/foo', '/foo/bar'])(
    `returns ${RouteName.NotFound} for path %s`,
    (pathname: string) => {
      expect(routeNameFromPathname(pathname)).toEqual(RouteName.NotFound);
    },
  );
});
