import { match } from 'path-to-regexp';
import { Enum } from 'tachyon-utils';
import { RouteLinkRawPaths, RouteName } from '../routes';

/**
 * Converts a raw path to a RouteName, gracefully handling any query params.
 * Returns NotFound if there is no matching path.
 */
export function routeNameFromRawPath(path: string): RouteName {
  const pathname = path.split('?')[0];
  const routeName = Enum.keys(RouteLinkRawPaths).find((route) =>
    match(RouteLinkRawPaths[route])(pathname),
  );

  return routeName ?? RouteName.NotFound;
}
