import {
  RouteLinkBuilders,
  RouteLinkPathnames,
  RouteName,
  routeNameFromPathname,
} from '.';

describe(routeNameFromPathname, () => {
  it.each(Object.entries(RouteLinkPathnames))(
    'returns %s for path %s',
    (routeName: string, pathname: string) => {
      expect(routeNameFromPathname(pathname)).toEqual(routeName);
    },
  );

  it.each(['/foo', '/foo/bar'])(
    `returns ${RouteName.NotFound} for path %s`,
    (pathname: string) => {
      expect(routeNameFromPathname(pathname)).toEqual(RouteName.NotFound);
    },
  );
});

describe('RouteLinkBuilders', () => {
  it.each(Object.values(RouteName))('builds href for %s', (route) => {
    const [actualHref, expectedHref] = (() => {
      if (route === RouteName.External) {
        const externalHref = 'https://www.twitter.com/';
        const { href } = RouteLinkBuilders[route]({ href: externalHref });
        return [href, externalHref];
      }

      const { href } = RouteLinkBuilders[route]({} as any);
      return [href, RouteLinkPathnames[route]];
    })();

    expect(actualHref).toEqual(expectedHref);
  });
});
