import {
  ACCESS_TOKEN_FRAGMENT_PARAM,
  REFRESH_TOKEN_FRAGMENT_PARAM,
} from '../../config';
import { getAccessAndRefreshTokenFromUrlFragment } from '.';

describe(getAccessAndRefreshTokenFromUrlFragment, () => {
  const urlBase = 'https://tv.twitch.tv';
  it.each`
    url                                                                                                             | expectedReturn
    ${urlBase}                                                                                                      | ${undefined}
    ${`${urlBase}#`}                                                                                                | ${undefined}
    ${`${urlBase}#${ACCESS_TOKEN_FRAGMENT_PARAM}%3Daccess-token`}                                                   | ${{ accessToken: 'access-token' }}
    ${`${urlBase}#${ACCESS_TOKEN_FRAGMENT_PARAM}%3Daccess-token%26${REFRESH_TOKEN_FRAGMENT_PARAM}%3Drefresh-token`} | ${{ accessToken: 'access-token', refreshToken: 'refresh-token' }}
    ${`${urlBase}#${REFRESH_TOKEN_FRAGMENT_PARAM}%3Drefresh-token`}                                                 | ${undefined}
    ${`${urlBase}#${ACCESS_TOKEN_FRAGMENT_PARAM}`}                                                                  | ${undefined}
  `(
    'returns $expectedReturn when the input is $url',
    ({ expectedReturn, url }) => {
      expect(getAccessAndRefreshTokenFromUrlFragment(url)).toEqual(
        expectedReturn,
      );
    },
  );
});
