# Twitch Status Page

Twitch's Status Page. Hosted at https://status.twitch.tv/

We use a
[custom header](https://support.atlassian.com/statuspage/docs/use-custom-html-on-a-status-page/)
to customize the status page.

## Design

The current mock is Frame 36 titled 'Updated'
[here](https://www.figma.com/file/8RBDJww2ifLpRYzmdD7AJ1/Availability-Page?node-id=0%3A1)

## Caveats

The status page does not have Core-UI and is currently using jQuery. Also, it
has pretty limited ability to change things so it's design is a best effort.

## Support Matrix

Latest Chrome.

## Development

### Overview

Ultimately, our status page is managed through the statuspage.io UI. We include
relevant files in this repo for version control. There are two files in this
repo that need to be synchronized with statuspage.io (everything else exists for
local development):

- custom-header.html
- colors.txt

custom-header.html is copy-and-pasted directly into the statuspage.io textbox
(see deployment below). the values in colors.txt are pasted into their
identically named textboxes in the statuspage.io UI.

An index.ejs file is provided as best effort approximation of statuspage.io for
local development. This file was copy and pasted from statuspage.io, and injects
the custom-header.html file. Here is an
[overview of the statuspage.io process](https://support.atlassian.com/statuspage/docs/use-custom-html-on-a-status-page/).
Alternatively, statuspage.io provides an editor on their webpage that can be
used for development. If the color palette is updated through the GUI on
statuspage.io, the index.ejs file can be updated (either through copy and paste,
or updating the `window.pageColorData` section). If we want to invest more in
local development, the `pageColorData` could be pulled from the `colors.txt`
file via ejs.

### Tooling

`yarn start` will build the index.html and serve it. It will live reload changes
when `custom-header.html` is updated.

- [EJS](https://ejs.co/) for templates

### Philosophy

To minimize manual steps, we're only using the custom header and color palette
functionality of statuspage.io. We're not currently using a custom stylesheet,
nor a custom footer.

All custom styling is inline through the `style` attribute. Any class names that
exist are provided by statuspage.io. These provided class names are partially
documented
[here](https://support.atlassian.com/statuspage/docs/use-custom-css-on-a-status-page/).

Style overrides and JavaScript DOM manipulation are performed in `style` and
`script` tags, respectively, in the custom header. These could be broken out
into the custom stylesheet and custom footer, respectively, but that increases
the number of manual steps necessary to keep things synchronized.

## Deployment

NOTE: Static assets are deployed through TMW's TC build process. Any static
asset changes need to be in TMW's `public/static` folder, and will be accessed
via a TMW URL.

1. Verify your proposed changes:
1. Go to the design page for the
   [Twitch Test Account](https://manage.statuspage.io/pages/jhb74y7fflnz/full-customize)
1. Paste the contents of `custom-header.html` into the `Custom Header HTML`
   section
1. Click 'Publish Changes' to update the test page and verify output
1. Go to the design page for
   [Twitch Status](https://manage.statuspage.io/pages/yfj40zdsk34s/full-customize)
1. Paste the contents of `custom-header.html` into the `Custom Header HTML`
   section
1. Click 'Publish Changes'
