# Tomorrow (Mobile Web)

Check it out: <https://m.twitch.tv>.

## Getting Started

1. [Setup your Dev Environment](#setting-up-your-dev-environment).
1. [Setup your devices for local testing](./processes/device-testing.md).
1. [Review the documentation on local development](#local-development).
1. [Familiarize yourself with our patterns and best practices](./patterns/README.md).

## Setting Up Your Dev Environment

1. Ensure that you have run through the
   [First Time Setup](https://git.xarth.tv/pages/emerging-platforms/tachyon) for
   Tachyon
1. Integrate ESLint into your IDE.
1. Setup Prettier to
   [automatically run on save](https://prettier.io/docs/en/editors.html) in your
   IDE.
1. Run `yarn start` from `./apps/tomorrow` to run Tomorrow locally.

## App Architecture (Read Before Starting Development!)

Tomorrow is a Universal React ([Next.js](https://nextjs.org/docs/#setup)) app:

- We do not yet support login.
- In general user-specific data (RequestInfo, Recommendations, etc) cannot be
  fetched on the server to prevent cache poisoning
- Client specific behavior needs to be deferred until the app is initialized on
  the client
- The user's first request is served via Server Side Rendering (SSR) and
  CDN-level caching to deliver the first page. Subsequent navigation and
  data-fetching happens on the client.

Tomorrow uses [Tachyon-Relay](../../packages/tachyon-core/relay) for GQL
interaction:

- A single GQL query per page is allowed. Read
  [this](https://relay.dev/docs/en/thinking-in-relay) primer before starting
  development.
- Utilize [Fragment Containers](https://relay.dev/docs/en/fragment-container) to
  break down page behavior into smaller self-contained features.
- Use [Refetch Containers](https://relay.dev/docs/en/refetch-container) to
  refresh or change data in a Fragment Container.
- We support the user-specific RequestInfo query via the "withRequestInfo" HOC
  which is only available on the client.

Component Libraries & Styling:

- [Core-UI](https://design.xarth.tv/user-interface/getting-started)
- [Styled Components](../../patterns/styling-components.md) for Custom CSS

## More Documentation

Check out our various [Tachyon patterns](../../Patterns) in Tachyon and Tomorrow
specific [patterns](./patterns/README.md) for best practices and approaches for
creating pages, features, and using platform capabilities.

## App Infrastructure

The infrastructure used to serve the Tachyon app is described in an
[architecture document](https://docs.google.com/a/justin.tv/document/d/10eR2UpK-FL8wjgjgAGKiOubu47ZrQGgxmuTnThf0vPg/edit?usp=sharing).

## Feature Ownership

Ensure that you and your team understand
[Tomorrow's Feature Ownership Policy](../../policies/feature-ownership.md).

## Local Development

### Running Locally

```sh
yarn start
```

Note for Firefox users: In order to support HTTPS in local development, we use a
self-signed certificate that is added to your system keychain. Because Firefox
maintains its own keychain, when your browser first attempts to load the app it
will attempt to prevent you from visiting the site. You will need to override
its warning by clicking the "Advanced" button on this error page:

![iOS Simulator Manage Devices](../sky-map/public/static/tomorrow/processes/local-development/ff-untrusted-https-page.png)

#### Simulating A Production Build Locally

If you need to run TMW locally as a fully optimized production build:

```sh
yarn prodlike
```

#### Profiling A Production Build With [React Profiler](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)

Runs `prodlike` with a slightly
[altered build](https://gist.github.com/bvaughn/25e6233aeb1b4f0cdb8d8366e54a3977)
of React:

```sh
yarn profile
```

#### Running A Production Environment Locally

If you need to run a full Docker Tomorrow environment locally, from the root of
Tachyon:

```sh
yarn docker:tmw
```

Then visit `localhost:3003`.

### Running Unit Tests

Tachyon uses [Jest](https://jestjs.io/docs/en/cli) to run unit tests:

```sh
yarn test [TestPathPattern]
```

Or for watch mode:

```sh
yarn test:watch [TestPathPattern]
```

### Code Formatting

#### Linting & Prettier via [ESLint](https://eslint.org/)

```sh
yarn lint:fix
```

_Note: Integrate ESLint into your IDE for the best experience._

## Korean Entity Information

Tomorrow and Starshot share the underlying implementation of the Korean Entity
Information modal, which is located in the `tachyon-more-ui` package. This is to
ensure a consistent look/feel and localization across both apps.
