# CDN Caching

There are three importants notes about caching in Tachyon Mobile Web:

1. **Using data from the request that is not in the cache key leads to cache
   corruption and is very dangerous.**
1. The production Fastly CDN is not available in staging environments. This
   means that caching does not work the same in staging as it does in
   production. This is intentional so that developers don't get confused when
   being served stale versions of their new code.
1. The
   [Fastly config](https://git.xarth.tv/CPE-Ops/fastly-config/blob/main/mobile/mobile.vcl)
   is the canonical source for this information and, because it is maintained by
   a different team, might have newer data than this doc.

## Caching Strategy

### Defining a Cache Entry

The Fastly config defines a
[set of parameters](https://git.xarth.tv/CPE-Ops/fastly-config/blob/main/mobile/mobile.vcl#L313-L338)
that are used to uniquely identify a page. Those parameters are combined into a
string and used as a cache key. Each value in the cache key is schemaless; it is
a string value with no practical constraint.

These parameters are currently:

1. Fastly-specific
   1. [Fastly-GeoIP-CountryCode](https://developer.fastly.com/reference/vcl/variables/geolocation/geoip-country-code/)
1. HTTP Headers
   1. [Accept-Language](https://tools.ietf.org/html/rfc2616?spm=5176.doc32013.2.3.Aimyd7#section-14.4) -
      this header represents a coalesced and normalized value of a few possible
      sources (see below)
   1. Experiment-Bucket - The bucket (a through i) the CDN assigns the request
      into based on `unique_id` for `tachyon-experiments`.
1. Cookie
   1. prefers_color_scheme - controls the color scheme rendered on the server
1. [Query String Parameters](https://tools.ietf.org/html/rfc3986#section-3.4)
   1. desktop-redirect - indicates if the CDN redirected from www, also if the
      page was redirected from an offline channel page
   1. theme - used by Tesla (migrating to tachyon-prefers-color-scheme cookie)
   1. term - for search (search pages only)
   1. category - for search (search pages only; deprecated, being replaced by
      type)
   1. type - for search (search pages only)
   1. tl - indicates tags to filter a browser directory on (directory pages
      only)

**Locale/Language**: There are a few sources of preference that the CDN takes
into account. It reads the `language` cookie first, representing an explicit
user choice. Next it will look for the `lang` query param, normally representing
a search bot (like googlebot) that is crawling our html meta and doesn't have
the ability to manipulate `Accept-Language` headers. Lastly it will look at
`Accept-Language` header representing the user's device settings. The CDN will
then normalize that value (`Accept-Language` can be a list of fallback choices)
to the list of Twitch-supported locales and then set that value in the
`Accept-Language` header passed onto the origin.

## Caching Strategy on Receiving a Request

When the CDN receives a request it passes the aforementioned parameters into a
pure function that generates a cache key. If that cache key hits against the
cache the CDN will check the TTL to determine if the cached content is still
fresh enough to serve. If it is within the constraint of `max-age` then the CDN
will forego sending the request to origin and serve the cached content. If it is
within the constraint of `stale-while-revalidate` then it will serve the cached
page **and** fetch a new page from origin. If a cache miss occurs or the cached
content is too stale then the request is forwarded to origin.

**NOTE**: The CDN _does not_ filter the parameters that it does not use as a
cache key out of the request. This means that origin receives data in the
request on which it would be dangerous to vary the rendering of content.

## Caching Strategy on Origin Error

If the CDN receives a response back from origin in the 5xx range it re-checks
its cache. If it gets a cache hit and the data is fresh enough within the
context of the `stale-if-error` directive then it will serve the cached content.
If no sufficiently fresh content exists it will respond to the client with the
error page from origin.

## Caching Strategy on Origin Success

When the CDN receives the response from origin and it is a 2xx or 3xx response
it will do the following:

1. Serve the response back to the client.
2. Generate a new cache key and store the content at that key along with the TTL
   for when to bypass origin and serve the content, when to serve the content
   while fetching from origin, and when to serve the content if origin returns
   an error.
