# Tachyon Mobile Web Service Dependency Policy

The Tachyon platform does not define policies or procedures around how to deal
with upstream dependencies. However, certain packages provided, like
tachyon-event-reporter or tachyon-experiments, provide best practice default
implementations. This document defines what dependencies Tachyon Mobile Web has
and how it handles their degradation.

The upstream dependencies for Tachyon Mobile Web are:

- GraphQL (Tier 1).
- The spade ingest URL provider (Tier 2?, unclear).
- Spade ingest service (Tier 2).
- Minixperiment data provider (Tier 2).

## Service Degradation

The following sections explain how we handle degradation across these.

### GraphQL

Most pages Tachyon Mobile Web delivers requires two GQL requests:

- Request info
- Main content

The request info query powers geographically fenced legal notifications. Based
on direction from legal, if the GQL request fails for these then we do not show
legal notifications.

The main content request powers the content below the navigation bar on the
page. Due to performance constraints, both regarding cellular network round trip
times and cross-region network requests, we perform a single request to fetch
all content. Under advisement from the Edge team we do not currently allow pages
to consume partially failed GQL responses without special consideration. As
such, if the services providing data for the main content fail the main content
area renders error content similar to Twilight's Dead Glitch, though in this
case it is a minecart flying off the rails.

In addition, the page always sends a 502 error code by design. Sending a 5xx
error code allows us to do two things: improve search engine results and
leverage CDN caching. A 5xx error code signals to search engines that the page
should not be cached or indexed. This is different than Twilight's approach
which sends a 200 and relies on various search engine's heuristics for "soft
error" states. However, it is less ambiguous on what a search engine should do.

Also, by sending a 5xx status code we can indicate to Fastly that the result is
an error and use their "stale-if-error" support. Successful pages send a
"stale-if-error" cache control of 30 minutes by default. Because of this Fastly
can replace our error page with an older version of the page if that POP has
seen one in the last half an hour.

### Spade Ingest URL Provider

Tachyon Mobile Web relies on the approaches baked into
[tachyon-dynamic-settings](../../../../packages/tachyon-core/dynamic-settings/).

### Spade Ingest Service

Tachyon Mobile Web relies on the approaches baked into
[tachyon-event-reporter](../../../../packages/tachyon-core/event-reporter/).

### Minixperiment data provider

Tachyon Mobile Web relies on the approaches baked into
[tachyon-experiments](../../../../packages/tachyon-core/experiments/).
