import { cy, it } from 'local-cypress';

describe('Search', () => {
  it('shows autocomplete and then full search results when starting from Homepage', () => {
    const typedText = 'counter';
    // Load home page
    cy.visit('/');
    // Click search icon
    cy.get('[aria-label=Search]').click();
    // Check we are on search page now
    cy.location('pathname').should('eq', '/search');
    // Confirm search bar is focused element
    cy.get('nav').focused();
    // Enter search term
    cy.get('input[type=search]')
      .type(typedText)
      .should('have.value', typedText);
    // Ensures autocomplete options are present in search content
    // (first entry just mirrors text so we expect more than one)
    cy.getSc('ScSearchContent').find('li').should('have.length.gt', 1);
    // Submit search
    cy.get('input[type=search]').type('{enter}');
    // Confirm the four categories exist
    cy.getSc('ScSearchContent').find('section').should('have.length', 4);
  });
});
