import { before, cy, expect, it } from 'local-cypress';
import { fetchDynamicSettings } from 'tachyon-dynamic-settings';
import type { TwitchEvent } from 'tachyon-type-library';
import { identity, unspadeifyEvents } from 'tachyon-utils';

describe('Homepage', () => {
  let spadeUrl: string;
  // TODO: extract this into a resuable utility
  before(async () => {
    const res = await fetchDynamicSettings({
      app: 'tomorrow',
      // we'll need to vary this somehow
      appEnvironment: 'development',
      appGroup: 'tachyon',
      processor: identity,
    })();
    spadeUrl = `${res.spadeUrl}?allow_stream=true`;
  });

  it('emits pageview event on load', () => {
    // Spy on network request to spadeURL
    cy.intercept(spadeUrl).as('spadeUrl');
    // Load home page
    cy.visit('/');
    // Wait for spade request
    cy.wait('@spadeUrl').then((xhr) => {
      // Grab base64 form data
      const encodedData = (xhr.request.body as string).split('data=')[1];
      // Convert to JSON object
      const decodedData = unspadeifyEvents<TwitchEvent>(encodedData);
      // Find pageview event in reported batch
      expect(decodedData.some(({ event }) => event === 'pageview')).to.be.true;
    });
  });
});
