const { join } = require('path');
const { readIniFile } = require('tachyon-server-utils');

const {
  auth: { dsn: sentryDsn },
} = readIniFile(join(__dirname, '.sentryclirc'));

const buildId = process.env.GIT_COMMIT
  ? `tmw-${process.env.GIT_COMMIT.slice(0, 7)}`
  : 'tmw-dev';
const nextAssetPrefix = process.env.NEXT_ASSET_PREFIX || '/';

const transforms = {
  'process.env.BUILD_ID': buildId,
  'process.env.NEXT_ASSET_PREFIX': nextAssetPrefix,
  'process.env.SENTRY_DSN': sentryDsn,
};

module.exports = {
  buildId,
  nextAssetPrefix,
  transforms,
};
