const configurator = require('../../jest.configurator');

module.exports = configurator({
  moduleNameMapper: {
    'react-router-dom': 'tachyon-noop',
    '^tachyon-styles/(.*)$': '<rootDir>/tachyon-styles/$1',
    '\\.woff2?$': '<rootDir>/src/__mocks__/url-loader.js',
  },
  setupFiles: ['./setupTests.ts'],
  setupFilesAfterEnv: ['./setupTestsAfterEnv.ts'],
  testEnvironmentOptions: {
    url: 'https://m.twitch.tv',
  },
  transform: {
    '^.+\\.tsx?$': ['babel-jest', { cwd: __dirname }],
  },
});
