# Load Testing

We use [Artillery](https://artillery.io/docs/getting-started/) for load testing.

## Starting The Server In Load Test Mode:

Start Tachyon in a load test configured state:

```sh
yarn loadtest:prep
```

## Running A Load Test

| Command                 | Type                          | RPS | Duration   |
| ----------------------- | ----------------------------- | --- | ---------- |
| `yarn loadtest:start`   | Channel / VOD / Games         | 15  | 75 minutes |
| `yarn loadtest:popular` | Popular TMW URLS (6600 total) | 15  | 75 minutes |

## Checking For A Server Memory Leaks

1. Open Chrome and navigate to `chrome://inspect` and click "inspect" on the
   Node server.
1. Navigate to the "Memory" tab in the Inspector.
1. Start the load test.
1. While this is running, take periodic memory snapshots using the Memory
   Inspector.
1. Click on the second or later snapshot and change the view to "Comparison".
1. If there are any "Retainers", this indicates a leak. Dig in.
1. If there are no "Retainers", but heap entries continue to grow over time, dig
   in.

**Related resources:**

1. https://developers.google.com/web/tools/chrome-devtools/memory-problems/heap-snapshots#comparison_view
