# Tomorrow Application Pages

A "Page" is a designation in Tachyon for a React component that has the
following characteristics:

- it is routable via a URL path
- it is responsible for handling layouts in horizontal and landscape
  orientations
- it is responsible for requesting data, if required and validating the result
  on behalf of its child components
- it will render a 404 page appropriately

## Creating A New Non-Video Playback Page

For non-Player pages, refer to the general
[Tachyon Page](../../../patterns/creating-next-app-pages.md) Docs. These pages
should extend `TomorrowPage` (`components/types.ts`) rather than using
`TachyonPage`.

## Creating A New Video Playback Page

Pages that include Video Playback must extend Tomorrow's `PlayerLayout` class
component. This layout simplifies layout concerns for portrait and landscape
mode.

Refer to the [Tachyon Page](../../../patterns/creating-next-app-pages.md) docs
for advanced functionality.

## Rendering a 404 state

If your page represents an entity that might not exist (such as
user/channel/etc), your page should be able to handle 404 states. Each page
must:

1. Set the proper status code on the server in order to signal to our framework
   when your page is going to 404. This is accomplished by implementing a
   `isNotFoundServerside` static function on the Page.

1. Render its own 404 experience.

Use the
[Checking For Nullable Objects](../../../patterns/creating-next-app-pages.md#checking-for-nullable-objects)
approach to validate the top-level page object to accomplish these goals as seen
in the example below:

```tsx
import { NotFoundErrorLayout } from '../../layouts';
import { TomorrowPage } from '../types.ts';

type SomePageProps = { foo: string | null };

function validFoo(foo: Foo): foo is NonNullable<SomePageProps['foo']> {
  return !!foo;
}

const SomePage: TomorrowPage<{}, SomePageProps> = ({ foo }) => {
  if (!validFoo(foo)) {
    return <NotFoundErrorLayout />;
  }

  /* render valid page content */
};

SomePage.isNotFoundServerside = ({ foo }) => {
  return !validFoo(foo);
};
```
