# Local Device Testing

It is important to test pages and features using simulated or real mobile
devices similar to those of actual Tomorrow. To simplify this process, Tomorrow
supports helpful commands to launch a simulator with the locally running app
pre-opened.

Requirements:

- You've run `./scripts/start` in `tomorrow`.
- You've finished the "Setting Up Simulation Devices" section below.
- Tomorrow is running locally via `yarn start`.

**iOS (requires: "Setting Up An iOS Simulator"):**

Open the target simulator (iPhone 11, iPad Pro, etc). Then run the following
command to open the site in the simulator (or manually navigate there yourself):

```sh
$ yarn ios
```

**Android (requires: "Setting Up An Android Simulator")**

```sh
$ yarn android
```

_NOTE_: It's recommended to select "Always Open in Chrome" for future
convenience.

## Setting Up An Android Simulator

### OSX

1. Ensure that you've successfully run `./scripts/setup` from the repository
   root.
1. Run `yarn android`. If this succeeds, you are good to go!

### Other OS's

1. Download and install [Android Studio](https://developer.android.com/studio/).
1. Create a new project in Android Studio (name doesn't matter).
1. Click the "AVD Manager" button:

![AVD Manager Button](../../sky-map/public/static/tomorrow/processes/device-testing/avd-manager-button.png)

1. [Create a Virtual Device](https://developer.android.com/studio/run/managing-avds)
   using API 26 (Oreo 8.0) named "MWEB_ANDROID_8.0" (necessary for
   `yarn android`).
1. Run `yarn android`. If this succeeds, you are good to go!
1. You can create other API versions in AVD Manager, and as long as they follow
   the same pattern (e.g. "MWEB_ANDROID_6.0" for API 23), you can then launch
   them with `AOS=6.0 yarn android` (8.0 is the default).

## Debugging Your Android Simulator

### Remote Chrome Dev Tools Debugging

For debugging application when running Chrome on Android, see:
https://developers.google.com/web/tools/chrome-devtools/remote-debugging/

### Accessing the Virtual Device's Terminal

To open a terminal within the file system of your running AVD emulator:

```sh
$ adb shell
```

Ensuring the simulator can reach your running Tomorrow local development server:

```sh
$ adb shell
$ ping localhost.m.twitch.tv
```

## Setting Up An iOS Simulator

1. Install Xcode from the App Store. If that does not work, older versions of
   Xcode can be downloaded from
   [Apple's Developer Downloads site](https://developer.apple.com/download/more/).

2. Open Xcode and go to Window → Devices and Simulators to manage devices

![iOS Simulator Manage Devices](../../sky-map/public/static/tomorrow/processes/device-testing/ios-simulator-manage-devices.png)

3. Click the plus button in the bottom left to add new devices to your list.

![iOS Add New Device](../../sky-map/public/static/tomorrow/processes/device-testing/ios-simulator-add-device.png)

4. Select the OS Version dropdown and select "Download more simulator runtimes"
   to download other iOS versions. Older runtimes are available
   [here](https://drive.google.com/drive/folders/1SFWPoBfdGTDOB7DN3X6BanMwF8Y55sps).

![iOS New Device Settings](../../sky-map/public/static/tomorrow/processes/device-testing/ios-simulator-new-device-settings.png)

5. Download whatever versions you want.

![iOS Simulator Device Version](../../sky-map/public/static/tomorrow/processes/device-testing/ios-simulator-device-version.png)

6. Setup all your devices through the previous "Create a new simulator"
   dialogue.

7. Now go to Xcode → Open Developer Tools → Simulator, which will automatically
   start a Simulator

![XCode Simulator](../../sky-map/public/static/tomorrow/processes/device-testing/xcode-simulator.png)

8. You can select the device/OS you want from File → Open Simulator. You can
   also create new simulators by selecting "New Simulator" from the dropdown

![iOS Simulator Device Menu](../../sky-map/public/static/tomorrow/processes/device-testing/ios-simulator-device-menu.png)

9. Once the simulation has loaded, open up Safari and go to the URL you want to
   test. **NOTE** because this is a simulation running on your laptop the
   simulated device can access the local network and respects your /etc/hosts
   entry.
10. Set the XCode Command Line Tools to use in Xcode → Preferences

![Set XCode CLI Version](../../sky-map/public/static/tomorrow/processes/device-testing/xcode-set-cli-version.png)

11. Once you've loaded the page open desktop Safari and open the debugger for
    your simulator via Develop → Simulator → [title of the page you are
    debugging]. **NOTE** If you don't have a debug menu then see "Setting up
    debugging in Safari" below.

![iOS Simulator Open Safari](../../sky-map/public/static/tomorrow/processes/device-testing/ios-simulator-open-safari.png)

## Local Testing With Physical Devices

### Testing on an Android Device

Google Chrome has Android Debug Bridge (ADB) built into it now. Because of this
it is trivial to live test a page on an Android device as though it were local,
regardless of whether the page is in Chrome or a WebView. This includes the
ability to simulate network conditions, clear caches, set breakpoints, and live
modify the DOM.

Note: This section of the guide is based on
[Google's docs on the matter](https://developer.chrome.com/devtools/docs/remote-debugging),
but is shorter, more up to date, and customized a bit for our use case. Still,
it is good to refer to the source material for more information.

#### Putting an Android Device into Developer Mode

See
[this guide](http://developer.android.com/tools/device.html#device-developer-options)
on enabling developer mode on an Android device. **Then use the same guide to
enable USB Debugging.**

#### Connecting the Device

1. Ensure your device is in 'Developer Mode'
1. Plug the device that you wish to test into your computer via a USB cable.
1. Open Chrome and go to `chrome://inspect/#devices` (Note: For security
   reasons, Chrome won't let that be a clickable link) (Tip: Bookmark that page
   if you are doing a lot of device testing). If the device doesn't show up, you
   may need to check your android file transfer settings; unplug and plug to try
   again. Windows: https://support.google.com/nexus/answer/2840804?hl=en >
   Windows Transfer Mac: http://www.android.com/filetransfer/
1. As soon as you go to this page the Android device will pop up a modal asking
   if you want to trust this computer for USB debugging, click "OK." Note: If
   this dialog does not pop up make sure the "Discover USB devices" box is
   checked at the top of the Devices Inspector page in Chrome.
1. Click the Port Forwarding button to enable mapping ports from the device to
   the computer. Note: This is from the perspective of the computer, so if you
   want to map to something running locally you'll want to map it to localhost.
   Here's an example config:

![Port Forwarding Settings](../../sky-map/public/static/tomorrow/processes/device-testing/android-port-forward-settings.png)

1. Verify the "Enable port forwarding" box is checked at the bottom of the modal
   and click Done.
1. Once this is done you should see the list of devices available, along with
   all the pages currently open. Here's an example:

![Chrome Available Devices](../../sky-map/public/static/tomorrow/processes/device-testing/chrome-available-devices.png)

1. Note, you can use this to inspect pages inside of Twitter & I think Facebook,
   but I don't have that installed to verify. The second page is actually a view
   inside of Twitter.
1. I don't have a lot of success with the Focus Tab link. Instead, just open the
   app and bring that view into focus.
1. Click the Inspect link in the Device Inspector page. This'll bring up a
   nearly full featured instance of Chrome Inspector.
1. Have a reasonably enjoyable time testing.

#### Getting Android to Recognize localhost.m.twitch.tv as Your Computer

Unless the device is rooted so that you can modify /etc/hosts then you'll need
to setup a DNS server or proxy to direct your device to your computer for
localhost.m.twitch.tv. This part of the guide will go over using Charles Proxy
to proxy requests through the computer, allowing requests to
localhost.m.twitch.tv to DWYM. Charles Proxy is nice because it is (reasonably)
user friendly, allows you an option for throttling without using Chrome
Inspector, & is already available through a site license with Amazon.

##### Testing A Tomorrow Staging on Android

The easiest way to test a staging branch with an Android physical device is to
deploy Tomorrow to one of
[Tachyon's public staging environments](../../processes/using-public-staging-environments.md).

### Testing on an iOS Device

Note: iOS only supports debugging in mobile Safari & any apps built and
sideloaded. It does not support debugging apps installed through the App Store,
e.g. Chrome, Facebook, Twitter. This shouldn't be too much of a problem since
they all use UIWebView though, hopefully.

#### Setting up iOS Mobile Web Inspector with Safari

1. Open Settings on the iOS device.
1. Scroll down to Safari preferences.
1. Click Advanced in Safari preferences:

![iOS Safari Advanced Preferences](../../sky-map/public/static/tomorrow/processes/device-testing/ios-safari-advanced-preferences.jpg)

1. Tap the slider to enable Web Inspector:

![iOS Safari Web Inspector](../../sky-map/public/static/tomorrow/processes/device-testing/ios-safari-web-inspector.jpg)

#### Setting up debugging in Safari

1. Click Safari → Preferences in the menu.
1. Hit the Advanced button.
1. Click "Show Develop menu in menu bar":

![Desktop Safari Advanced Preferences](../../sky-map/public/static/tomorrow/processes/device-testing/desktop-safari-develop-menu.png)

#### Debugging a mobile page in Safari

1. Connect the device via a USB cable (remote debugging via wifi is not
   available).
1. Open Safari.
1. In the main menu go to Developer → device you are testing on → page with
   which you want to interact.

![iOS Simulator Open Safari](../../sky-map/public/static/tomorrow/processes/device-testing/ios-simulator-open-safari.png)

#### Proxying Requests on iOS

Unfortunately proxying requests through your development machine (so as to be
able to access localhost.m.twitch.tv) requires using something like Charles
Proxy to setup an open proxy
([source](https://www.charlesproxy.com/documentation/faqs/using-charles-from-an-iphone/)).
This is messy.

## Simulating Mobile Devices In The Browser

### Google Chrome via Web Inspector

Google Chrome supports the ability to simulate various devices through Chrome
Inspector. This is a pretty weak simulation, the actual functionality will be
different so it is not sufficient to prove something works properly on mobile.

#### Simulating a Mobile Device

1. Press `Command + Option + i (or control + alt + i)` inside of Chrome to bring
   up the web inspector.
1. Click the "Toggle Device Mode" button
   (![Toggle Device Mode](../../sky-map/public/static/tomorrow/processes/device-testing/toggle-device-mode.png)).
1. Select the device from the device dropdown above the page.
1. Reload the page so any JS browser checks get the expected result.

#### Throttling Network Activity

1. Press `Command + Option + i (or control + alt + i)` inside of Chrome to bring
   up the web inspector.
1. Click the "Network" tab.
1. Select the proper network condition you wish to simulate from the dropdown
   shown here:

![Throttle Settings](../../sky-map/public/static/tomorrow/processes/device-testing/chrome-inspector-throttle.png)

1. (Optional) Select "Disable cache" to see what the activity will be like for a
   first-time visitor, or a visitor who hasn't visited recently.
