# Mobile Web Redirects

Terminology:

Desktop = www.twitch.tv (Twilight) Server = Tachyon Mobile Web's Node Server

## Mobile Web Redirect

When a user attempts to navigate to Desktop and our CDN determines the request
is coming from a mobile device, a redirect to m.twitch.tv with
`?desktop-redirect=true` will occur.

### Native App Upsell

When a user requests a complex route (2-3 path parts) that is not supported by
Mobile Web, we attempt to convert the user to a native application (which will
probably do a better job of handling this) via the Native Upsell page.

### Forcing Requests Back To Desktop

There are a number of application routes that Tachyon does not support. The CDN
will only redirect the user from Desktop to Mobile Web if it deems the requested
path is supported. In the event of CDN failure, the server also performs this
path support check and will redirect the user back to Desktop as necessary. This
list of paths lives at `tachyon-lib/config/redirects` in the
`pathsToForceRedirect` list.

### Updating the Redirect List

To add a new entry to this list (or remove one), you'll need to update the
`pathsToForceRedirect` list inside of tomorrow as well as update the CDN, which
can be done via the #clients-cdn Slack channel and/or a DELIVERY ticket.
