# Service Worker Development

Our Service Worker is generated from `workbox-webpack-plugin` from
[Workbox](https://developers.google.com/web/tools/workbox/). We use a wrapper
over `workbox-webpack-plugin` for Next called
[next-pwa](https://github.com/shadowwalker/next-pwa).

- transpiled by babel (`sw.babel.config.js`) and minified by terser
- configuration lives in `next.config.js`
- only works over HTTPS
- supported by [most modern browsers](https://caniuse.com/serviceworkers)

## Local Development

Running `yarn start` will result in the installation of a no-op Service Worker.
This is in order to prevent a previously installed and functional Service Worker
from causing unwanted caching behavior that is difficult to identify and
detrimental to most local development tasks. This service worker is in
`src/workers/development-service-worker.js`.

Running `yarn prodlike` will result in Tachyon's production service worker being
built and installed when the client is launched. Any changes to the service
worker resulting in the need for a new installation will not take place unless a
completely new browser session is launched, or the previous service worker is
manually de-registered.

## How the Service Worker is built

Our Service Worker is generated by next-pwa, and we then transpile and minify it
to ensure that it's usable by all of our consumers. Since workbox relies on APIs
that are Promise-based, we exclude Promise (`transform-regenerator`) from that
step (which otherwise targets Chrome 45 since it was the first version with full
SW support); we also gate SW registration to users with a globally available
Promise API in order to help prevent errors. We put the SW in the `public/`
directory so that Next will serve it. It must be served directly from the root
of `public/` to ensure it is properly
[scoped](https://developers.google.com/web/ilt/pwa/introduction-to-service-worker#registration_and_scope)
to run for all application routes.

## Debugging A Service Worker With Chrome Dev Tools

Start here:
[Debugging Service Workers](https://developers.google.com/web/fundamentals/codelabs/debugging-service-workers/)

TL:DR;

- The Service Worker will log messages in the console. Note: this must be opted
  into by setting `ENABLE_WORKBOX_LOGGING = true` in `next.config.js`.
- You can see its networks requests like normal in the Network tab.
- You can check it was installed and manage it by going to Application > Service
  Workers
- You can see files it has cached by going to Applications > Cache > Cache
  Storage

## Unregistering A Service Worker

You can manually unregister (turn off) a running Service Worker in Chrome Dev
Tools by going to Application > Service Workers and clicking "Unregister":

![Unregistering a Service Worker](../../sky-map/public/static/tomorrow/processes/service-worker/unregistering-a-service-worker.png)

Unregistering a SW is not always immediate, because a SW will attempt to finish
any queued work before exiting. Since we use the BackgroundSync API, we are
almost guaranteed to have queued work and thus you might have to wait a few
moments for things to clear.

## Resource

- Google Dev Docs on
  [Service Workers](https://developers.google.com/web/fundamentals/primers/service-workers/).
  Pretty much everything you need to know about how they work and best practices
  are captured here. Use this as your starting point for building domain
  knowledge.
