# Tracking Users

While Tomorrow doesn't have login, it does use some methods to track users'
interactions and behaviors across the app.

## Unique IDs

### Device ID

Device ID is the primary method for tracking repeat visits by otherwise
anonymous users. It is defined by our
[Data Science default properties](https://data.xarth.tv/events/default_properties.html#benchmark-default-properties).
For the Twitch web platforms, the device ID is stored in a standardized
`unique_id` cookie, which is set by VCL running in the Fastly CDN in order to
ensure that all users have this value properly set. Tomorrow will also set this
value on the express server if it does not find it already set, but (ideally)
this will only happen in local dev / staging environments in order to provide a
better DX and prevent errors (some GraphQL queries rely on finding a valid
device ID, for instance).

### Session ID

Session ID is used for tracking actions across users' individual visits. It is
defined by our
[Data Science default properties](https://data.xarth.tv/events/default_properties.html#benchmark-default-properties).
For Tomorrow, session ID is stored using the session storage API; this means
that it persists across refreshes (but not tabs). Since it is limited to a
single session, this value and implementation is not shared across the Twitch
web platforms.

## Accessing IDs

Developers do not need to worry about the implementation details about how the
various ID values are handled in Tomorrow, as the values are provided for easy
consumption by the
[tachyon-environment package](../../packages/tachyon-core/environment/README.md)
via the `withStaticEnvironment` HOC or `useStaticEnvironment` hook.

## Reporting IDs

Both device and session ID are reported with every spade event within the
Tachyon platform, so developers do not need to add these values themselves to
tracking payloads.
