# Using Tomorrow Staging Environments

## Main on Staging

The `main` branch is automatically deployed to both
https://2fsgxn2ycmkf1ilujxl3.tv.twitch.a2z.com (publicly available) and
https://master.mweb-staging.xarth.tv (only available on Amazon VPN) whenever it
is updated. You can check the status of the latest main staging deploy
[here](https://teamcity.xarth.tv/viewType.html?buildTypeId=EmergingPlatforms_Tachyon_StagingDeploytoMainStaging).

## Deploying A Branch To Staging

### Getting Started in TeamCity

1. The Tachyon build and deploy process lives in
   [TeamCity](https://teamcity.xarth.tv). When you first sign in, you'll want to
   favorite the "Tachyon" project for ease of use.

1. Expand the Tachyon project and click into "Tomorrow Staging" and favorite
   that as well.

## Deploying to Staging

1. To deploy to a staging environment, go to the
   ["Tomorrow Staging" page](https://teamcity.xarth.tv/project/EmergingPlatforms_Tachyon_TomorrowStaging)
   and click "Deploy" under "Deploy to Environment".

   _If you can't see the deploy button, ping #mobile-web in Slack and ask to be
   added to the TeamCity Group named "Tachyon Staging"._

1. On the "Parameters" tab of the deploy configuration, set "Tomorrow Staging
   Slot" to your desired environment (they are named after Mario kingdoms). Ask
   in #mobile-web if you need help choosing an available environment. A good
   rule of thumb is to use one that is not listed in the recent task history
   since it probably hasn't been used in a while.

1. On the "Changes" tab of the deploy configuration, set "Build branch" to your
   desired target. It is recommended to the use the label of your PR
   ("pull/XXXX"), rather than the branch name, in order to allow TeamCity to
   re-use all of the build artifacts from your CI process and have your deploy
   start immediately.

1. Click "Run Build" to start.

1. Once the build is complete, access at https://<kingdom>.mweb-staging.xarth.tv
   on wpa2.

## Accessing Staging Error Logs

After assuming a role in the twitch-cpe+mweb+staging@amazon.com via Isengard,
staging logs can be accessed
[here](<https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logs-insights:queryDetail=~(end~0~start~-900~timeType~'RELATIVE~unit~'seconds~editorString~'fields*20*40timestamp*2c*20*40message*0a*7c*20filter*20*40message*20like*20*2f*28*3fi*29error*2f*0a*7c*20filter*20*40message*20not*20like*20*2f*28Failed*20GQL*20request*7cHandling*20request*20for*29*2f*0a*7c*20sort*20*40timestamp*20desc~isLiveTail~false~queryId~'68348535-e20a-484d-bc0a-c25f8f9b37d0~source~(~'tachyon))>).

## Testing Staging With A Simulated Device

### Android

1. Follow the guide on [Setting Up An Android Simulator](../device-testing.md).
1. Run `yarn android`.
1. Navigate to the staging environment in the simulator.
   (https://<env-name>.mweb-staging.xarth.tv).

### iOS

1. Follow the guide on [Setting Up An iOS Simulator](../device-testing.md).
1. Open the target simulator (iPhone 11, iPad Pro, etc).
1. Navigate to the staging environment in the simulator.
   (https://<env-name>.mweb-staging.xarth.tv).

## Testing Staging With A Physical Device

The Tomorrow specific staging environments are only accessible on VPN which
would require the physical device to also have VPN access. Instead, Tomorrow can
be deployed to one of Tachyon's public staging environments using this
[process](../../../processes/using-public-staging-environments.md). Please do so
sparingly since these are also heavily used by the other Tachyon projects.
