import { datatype, internet, lorem } from 'faker';
import type { ClipPlayer_clip } from './__generated__/ClipPlayer_clip.graphql';

// istanbul ignore file: test mocks

export function mockClip(
  overrides?: Partial<ClipPlayer_clip>,
): ClipPlayer_clip {
  return {
    ' $refType': 'ClipPlayer_clip',
    broadcaster: {
      broadcastSettings: {
        isMature: false,
      },
      id: datatype.uuid(),
      login: internet.userName(),
      roles: {
        isPartner: datatype.boolean(),
      },
      self: null,
    },
    game: null,
    id: datatype.uuid(),
    slug: lorem.sentence(5),
    ...overrides,
  };
}
