import { clipPulsarParams } from 'tachyon-page-utils';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { BasePlayer } from '../BasePlayer';
import { mockClip } from './test-mocks';
import { PulsarClipPlayerBase } from '.';

describe(PulsarClipPlayerBase, () => {
  const setup = createShallowWrapperFactory(PulsarClipPlayerBase, () => ({
    clip: mockClip(),
  }));

  it('renders a BasePlayer', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(BasePlayer)).toHaveProp({
      params: clipPulsarParams({ clip: props.clip }),
    });
  });
});
