import { renderHook } from '@testing-library/react-hooks';
import {
  matureContentOverlay,
  playbackErrorOverlay,
  regionalBlockOverlay,
  unknownRestrictionOverlay,
} from '../../overlays';
import { useClipRestrictionOverlay } from '.';

jest.mock('tachyon-logger', () => ({ logger: { error: jest.fn() } }));

jest.mock('../../overlays/overlayMessages', () => ({
  matureContentOverlay: jest.fn(),
  playbackErrorOverlay: jest.fn(),
  regionalBlockOverlay: jest.fn(),
  unknownRestrictionOverlay: jest.fn(),
}));
const mockMatureContentOverlay = matureContentOverlay as jest.Mock;
const mockPlaybackErrorOverlay = playbackErrorOverlay as jest.Mock;
const mockRegionalBlockOverlay = regionalBlockOverlay as jest.Mock;
const mockUnknownRestrictionOverlay = unknownRestrictionOverlay as jest.Mock;

describe('useClipRestrictionOverlay', () => {
  it.each`
    restriction                   | overlay                          | overlayName
    ${'gql-mature'}               | ${mockMatureContentOverlay}      | ${'matureContentOverlay'}
    ${'gql-sub-only'}             | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'gql-vod-muted-segments'}   | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'playback-error'}           | ${mockPlaybackErrorOverlay}      | ${'playbackErrorOverlay'}
    ${'player-auth-drm'}          | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'player-auth-geo'}          | ${mockRegionalBlockOverlay}      | ${'regionalBlockOverlay'}
    ${'player-auth-unknown'}      | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'player-auth-vod-sub-only'} | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
  `(
    'returns $overlayName when restriction is $restriction',
    ({ overlay, restriction }) => {
      renderHook(() =>
        useClipRestrictionOverlay({
          removeRestriction: jest.fn(),
          restriction,
        }),
      );
      expect(overlay).toHaveBeenCalled();
    },
  );
});
