import { datatype, internet, lorem } from 'faker';
import { convertToSafeID, convertToSafeUserID } from 'tachyon-relay';
import type { StreamPlayer_channel } from './__generated__/StreamPlayer_channel.graphql';

// istanbul ignore next: mock
export function mockStreamPlayerChannel(
  overrides?: Partial<StreamPlayer_channel>,
): StreamPlayer_channel {
  return {
    ' $refType': 'StreamPlayer_channel',
    broadcastSettings: { isMature: false },
    displayName: internet.userName(),
    hosting: null,
    id: convertToSafeUserID(datatype.uuid()),
    login: internet.userName(),
    offlineImageURL: null,
    roles: null,
    self: null,
    stream: {
      archiveVideo: null,
      game: { id: datatype.uuid(), name: lorem.words(5) },
      id: convertToSafeID('__stream', datatype.uuid()),
      previewImageURL: internet.url(),
      restrictionType: null,
      self: {
        canWatch: true,
      },
    },
    videos: null,
    ...overrides,
  };
}
