import { channelPulsarParams } from 'tachyon-page-utils';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { BasePlayer } from '../BasePlayer';
import { mockStreamPlayerChannel } from './test-mocks';
import { PulsarStreamPlayerBase } from '.';

describe(PulsarStreamPlayerBase, () => {
  const setup = createShallowWrapperFactory(PulsarStreamPlayerBase, () => ({
    channel: mockStreamPlayerChannel(),
  }));

  it('renders a BasePlayer', () => {
    const { props, wrapper } = setup();

    expect(wrapper.find(BasePlayer).prop('params')).not.toBeNull();
    expect(wrapper.find(BasePlayer)).toHaveProp({
      params: channelPulsarParams(props.channel),
    });
  });
});
