import { renderHook } from '@testing-library/react-hooks';
import type { PlayingChannel } from 'tachyon-page-utils';
import {
  channelOfflineOverlay,
  matureContentOverlay,
  nextVideoOverlay,
  playbackErrorOverlay,
  regionalBlockOverlay,
  subOnlyLiveOverlay,
  unknownRestrictionOverlay,
} from '../../overlays';
import { mockNextVideoEdges } from '../../utils/test-utils';
import type { StreamPlayer_channel } from '../__generated__/StreamPlayer_channel.graphql';
import { mockStreamPlayerChannel } from '../test-mocks';
import { useChannelRestrictionOverlay } from '.';

jest.mock('tachyon-logger', () => ({ logger: { error: jest.fn() } }));

jest.mock('../../overlays/overlayMessages', () => ({
  channelOfflineOverlay: jest.fn(),
  matureContentOverlay: jest.fn(),
  playbackErrorOverlay: jest.fn(),
  regionalBlockOverlay: jest.fn(),
  subOnlyLiveOverlay: jest.fn(),
  unknownRestrictionOverlay: jest.fn(),
}));
const mockChannelOfflineOverlay = channelOfflineOverlay as jest.Mock;
const mockMatureContentOverlay = matureContentOverlay as jest.Mock;
const mockPlaybackErrorOverlay = playbackErrorOverlay as jest.Mock;
const mockRegionalBlockOverlay = regionalBlockOverlay as jest.Mock;
const mockSubOnlyLiveVideoOverlay = subOnlyLiveOverlay as jest.Mock;
const mockUnknownRestrictionOverlay = unknownRestrictionOverlay as jest.Mock;

jest.mock('../../overlays/overlayControls', () => ({
  nextVideoOverlay: jest.fn(),
}));
const mockNextVideoOverlay = nextVideoOverlay as jest.Mock;

describe('useChannelRestrictionOverlay', () => {
  it.each`
    restriction                   | overlay                          | overlayName
    ${'gql-mature'}               | ${mockMatureContentOverlay}      | ${'matureContentOverlay'}
    ${'gql-sub-only'}             | ${mockSubOnlyLiveVideoOverlay}   | ${'subOnlyLiveVideoOverlay'}
    ${'gql-vod-muted-segments'}   | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'playback-ended'}           | ${mockChannelOfflineOverlay}     | ${'channelOfflineOverlay'}
    ${'playback-error'}           | ${mockPlaybackErrorOverlay}      | ${'playbackErrorOverlay'}
    ${'player-auth-drm'}          | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'player-auth-geo'}          | ${mockRegionalBlockOverlay}      | ${'regionalBlockOverlay'}
    ${'player-auth-unknown'}      | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'player-auth-vod-sub-only'} | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
  `(
    'returns $overlayName when restriction is $restriction',
    ({ overlay, restriction }) => {
      renderHook(() =>
        useChannelRestrictionOverlay({
          channel: mockStreamPlayerChannel(),
          playingChannel: mockStreamPlayerChannel() as PlayingChannel<
            Omit<StreamPlayer_channel, ' $refType'>
          >,
          removeRestriction: jest.fn(),
          restriction,
        }),
      );
      expect(overlay).toHaveBeenCalled();
    },
  );

  it('returns nextVideoOverlay for playback-ended when there is another video', () => {
    renderHook(() =>
      useChannelRestrictionOverlay({
        channel: mockStreamPlayerChannel(),
        playingChannel: mockStreamPlayerChannel({
          videos: { edges: mockNextVideoEdges() },
        }) as PlayingChannel<Omit<StreamPlayer_channel, ' $refType'>>,
        removeRestriction: jest.fn(),
        restriction: 'playback-ended',
      }),
    );
    expect(mockNextVideoOverlay).toHaveBeenCalled();
  });
});
