import { datatype, internet, lorem } from 'faker';
import type { mockNextVideoEdges } from '../utils/test-utils';
import type { VodPlayer_video } from './__generated__/VodPlayer_video.graphql';

export interface MockVideoOptions {
  mutedNodes?: Array<{ duration: number }>;
  nextVideos?: ReturnType<typeof mockNextVideoEdges>;
  overrides?: Partial<VodPlayer_video>;
  subscriptionProducts?: Array<{
    readonly displayName: string | null;
    readonly hasSubonlyVideoArchive: boolean | null;
  }>;
}

// istanbul ignore next: mock
export function mockVideo({
  mutedNodes,
  nextVideos,
  overrides,
  subscriptionProducts,
}: MockVideoOptions = {}): VodPlayer_video {
  return {
    ' $refType': 'VodPlayer_video',
    broadcastType: 'ARCHIVE',
    game: null,
    id: datatype.uuid(),
    muteInfo: {
      mutedSegmentConnection: { nodes: mutedNodes ?? [] },
    },
    owner: {
      broadcastSettings: {
        isMature: false,
      },
      displayName: lorem.word(),
      id: datatype.uuid(),
      login: internet.userName(),
      roles: {
        isPartner: datatype.boolean(),
      },
      self: null,
      subscriptionProducts: subscriptionProducts ?? [],
      videos: {
        edges: nextVideos ?? [],
      },
    },
    resourceRestriction: null,
    ...overrides,
  };
}
