import { vodPulsarParams } from 'tachyon-page-utils';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { BasePlayer } from '../BasePlayer';
import { mockVideo } from './test-mocks';
import { PulsarVodPlayerBase } from '.';

describe(PulsarVodPlayerBase, () => {
  const setup = createShallowWrapperFactory(PulsarVodPlayerBase, () => ({
    video: mockVideo(),
  }));

  it('renders a BasePlayer', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(BasePlayer)).toHaveProp({
      params: vodPulsarParams({
        vod: props.video,
      }),
    });
  });
});
