import { renderHook } from '@testing-library/react-hooks';
import {
  matureContentOverlay,
  mutedSegmentsWarning,
  nextVideoOverlay,
  playbackErrorOverlay,
  regionalBlockOverlay,
  subOnlyVideoOverlay,
  unknownRestrictionOverlay,
} from '../../overlays';
import { mockNextVideoEdges } from '../../utils/test-utils';
import { mockVideo } from '../test-mocks';
import { useVodRestrictionOverlay } from '.';

jest.mock('../../overlays/overlayMessages', () => ({
  matureContentOverlay: jest.fn(),
  playbackErrorOverlay: jest.fn(),
  regionalBlockOverlay: jest.fn(),
  subOnlyVideoOverlay: jest.fn(),
  unknownRestrictionOverlay: jest.fn(),
}));
const mockMatureContentOverlay = matureContentOverlay as jest.Mock;
const mockPlaybackErrorOverlay = playbackErrorOverlay as jest.Mock;
const mockRegionalBlockOverlay = regionalBlockOverlay as jest.Mock;
const mockSubOnlyVideoOverlay = subOnlyVideoOverlay as jest.Mock;
const mockUnknownRestrictionOverlay = unknownRestrictionOverlay as jest.Mock;

jest.mock('../../overlays/overlayControls', () => ({
  mutedSegmentsWarning: jest.fn(),
  nextVideoOverlay: jest.fn(),
}));
const mockMutedSegmentsWarning = mutedSegmentsWarning as jest.Mock;
const mockNextVideoOverlay = nextVideoOverlay as jest.Mock;

describe('useVodRestrictionOverlay', () => {
  it.each`
    restriction                   | overlay                          | overlayName
    ${'gql-mature'}               | ${mockMatureContentOverlay}      | ${'matureContentOverlay'}
    ${'gql-sub-only'}             | ${mockSubOnlyVideoOverlay}       | ${'subOnlyVideoOverlay'}
    ${'gql-vod-muted-segments'}   | ${mockMutedSegmentsWarning}      | ${'mutedSegmentsWarning'}
    ${'playback-ended'}           | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'playback-error'}           | ${mockPlaybackErrorOverlay}      | ${'playbackErrorOverlay'}
    ${'player-auth-drm'}          | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'player-auth-geo'}          | ${mockRegionalBlockOverlay}      | ${'regionalBlockOverlay'}
    ${'player-auth-unknown'}      | ${mockUnknownRestrictionOverlay} | ${'unknownRestrictionOverlay'}
    ${'player-auth-vod-sub-only'} | ${mockSubOnlyVideoOverlay}       | ${'subOnlyVideoOverlay'}
  `(
    'returns $overlayName when restriction is $restriction',
    ({ overlay, restriction }) => {
      renderHook(() =>
        useVodRestrictionOverlay({
          removeRestriction: jest.fn(),
          restriction,
          video: mockVideo(),
        }),
      );
      expect(overlay).toHaveBeenCalled();
    },
  );

  it('returns nextVideoOverlay for playback-ended when there is another video', () => {
    renderHook(() =>
      useVodRestrictionOverlay({
        removeRestriction: jest.fn(),
        restriction: 'playback-ended',
        video: mockVideo({
          nextVideos: mockNextVideoEdges(),
        }),
      }),
    );
    expect(mockNextVideoOverlay).toHaveBeenCalled();
  });
});
