import type { FC } from 'react';
import type { LayoutProps } from 'twitch-core-ui';
import {
  AlignItems,
  Background,
  BorderRadius,
  Color,
  Display,
  JustifyContent,
  Layout,
} from 'twitch-core-ui';

// istanbul ignore next: trivial
/**
 * Provides a high contrast layout for putting overlay content on top of
 * video / images. The content will be vertically centered.
 */
export const ContrastLayout: FC<LayoutProps> = (props) => (
  <Layout
    alignItems={AlignItems.Center}
    background={Background.Overlay}
    borderRadius={BorderRadius.Large}
    color={Color.Overlay}
    display={Display.Flex}
    justifyContent={JustifyContent.Center}
    margin={0.5}
    padding={{ x: 1, y: 0.5 }}
    {...props}
  />
);

ContrastLayout.displayName = 'ContrastLayout';
