import type { FC } from 'react';
import { memo } from 'react';
import styled from 'styled-components';
import { squareSize } from 'tachyon-more-ui';
import type { SVGAsset } from 'twitch-core-ui';
import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  JustifyContent,
  Layout,
  SVG,
} from 'twitch-core-ui';
import { ContrastLayout } from '../ContrastLayout';
import { PlayerOverlay } from '../PlayerOverlay';

const ScSvgContainer = styled.div`
  ${squareSize({ sizePct: 50 })};
`;

export interface FullScreenControlsOverlayProps {
  asset: SVGAsset;
  onTapOverlay: () => void;
  text?: string;
}

// istanbul ignore next: trivial
/**
 * Overlay designed for showing a player state and allowing the user to tap to
 * interact with the player.
 */
export const FullScreenControlsOverlayBase: FC<FullScreenControlsOverlayProps> =
  ({ asset, onTapOverlay, text }) => (
    <PlayerOverlay onTapOverlay={onTapOverlay}>
      <Layout
        alignItems={AlignItems.Start}
        display={Display.Flex}
        fullHeight
        fullWidth
        justifyContent={JustifyContent.Center}
      >
        <ContrastLayout
          flexDirection={FlexDirection.Column}
          fullHeight
          fullWidth
          margin={0}
        >
          <ScSvgContainer>
            <SVG asset={asset} fill />
          </ScSvgContainer>
          <Layout padding={{ top: 1 }}>
            <CoreText color={Color.Overlay} fontSize={FontSize.Size2}>
              {text}
            </CoreText>
          </Layout>
        </ContrastLayout>
      </Layout>
    </PlayerOverlay>
  );

FullScreenControlsOverlayBase.displayName = 'FullScreenControlsOverlayBase';

export const FullScreenControlsOverlay = memo(FullScreenControlsOverlayBase);
